/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.dialog;

import filenet.vw.api.VWInstructionDefinition;
import filenet.vw.api.VWInvokeInstruction;
import filenet.vw.api.VWPartnerLinkDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.VWAuthPropertyData;
import filenet.vw.toolkit.design.property.VWWebServiceUtils;
import filenet.vw.toolkit.design.property.dialog.VWCorrelationSetPanel;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.design.property.tables.VWCorrelationSetPropertiesTableModel;
import filenet.vw.toolkit.design.property.tables.VWInvokeCorrelationSetPropertiesTableModel;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWMessageDialog;
import filenet.ws.api.WSOperation;

class VWInvokeCorrelationSetPanel
extends VWCorrelationSetPanel {
    protected static final int MODE_INCOMING_MSG = 0;
    protected static final int MODE_OUTGOING_MSG = 1;
    private int m_nMode = 0;
    private VWInvokeInstruction m_invokeInstruction = null;

    public VWInvokeCorrelationSetPanel(VWAuthPropertyData authPropertyData, int nMode) {
        super(authPropertyData);
        this.m_nMode = nMode;
        this.init();
    }

    protected void onUpdateName() {
        String oldName = null;
        try {
            if (this.m_invokeInstruction != null) {
                switch (this.m_nMode) {
                    case 0: {
                        oldName = this.m_invokeInstruction.getInputCorrelationSetName();
                        if (VWStringUtils.compare(oldName, this.m_name.getText()) == 0) break;
                        this.m_invokeInstruction.setInputCorrelationSetName(this.m_name.getText());
                        break;
                    }
                    case 1: {
                        oldName = this.m_invokeInstruction.getOutputCorrelationSetName();
                        if (VWStringUtils.compare(oldName, this.m_name.getText()) == 0) break;
                        this.m_invokeInstruction.setOutputCorrelationSetName(this.m_name.getText());
                    }
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            if (this.m_authPropertyData != null) {
                VWMessageDialog.showOptionDialog(this.m_authPropertyData.getMainContainer(), ex.getLocalizedMessage(), 1);
            }
            this.m_name.setText(oldName);
            this.m_name.requestFocus();
        }
    }

    protected void reinitialize(VWInstructionDefinition instructionDef) {
        if (instructionDef instanceof VWInvokeInstruction) {
            this.m_invokeInstruction = (VWInvokeInstruction)instructionDef;
            switch (this.m_nMode) {
                case 0: {
                    this.m_name.setText(this.m_invokeInstruction.getInputCorrelationSetName());
                    break;
                }
                case 1: {
                    this.m_name.setText(this.m_invokeInstruction.getOutputCorrelationSetName());
                }
            }
            this.m_propertiesTableModel.reinitialize(this.m_invokeInstruction);
            this.m_sampleMsgTextArea.setText(this.getSampleMessage());
        }
    }

    protected VWCorrelationSetPropertiesTableModel createCorrelationSetPropertiesTableModel() {
        return new VWInvokeCorrelationSetPropertiesTableModel(this.m_authPropertyData, this.m_nMode);
    }

    private String getSampleMessage() {
        String partnerLinkName;
        if (this.m_invokeInstruction != null && (partnerLinkName = this.m_invokeInstruction.getPartnerLinkName()) != null && partnerLinkName.length() > 0 && this.m_authPropertyData != null) {
            try {
                WSOperation wsOperation;
                VWWebServiceUtils wsUtils = this.m_authPropertyData.getWebServiceUtils();
                VWPartnerLinkDefinition partnerLinkDef = this.m_authPropertyData.getPartnerLink(partnerLinkName);
                if (partnerLinkDef != null && wsUtils != null && (wsOperation = wsUtils.getOperationFromPartnerLink(partnerLinkDef, this.m_invokeInstruction.getOperationName())) != null) {
                    switch (this.m_nMode) {
                        case 0: {
                            return wsOperation.getXMLOutMessageTemplate();
                        }
                        case 1: {
                            return wsOperation.getXMLInMessageTemplate();
                        }
                    }
                }
            }
            catch (Exception ex) {
                VWDebug.logException(ex);
            }
        }
        return VWResource.s_unableToRetrieveSampleMessage;
    }
}

